﻿using System;

// Listing 4-26. Jawne zaimplementowanie jednego spośród interfejsów
class AFootInBothCamps : INamedPerson, ISettableNamedPerson
{
    private string settableName;
    // Standardowa składnia implementacji
    public string Name
    {
        get
        {
            Console.WriteLine("Odwołanie realizowane przy użyciu interfejsu INamedPerson.");
            return settableName;
        }
    }
    string ISettableNamedPerson.Name
    {
        get
        {
            return settableName;
        }
        set
        {
            Console.WriteLine(
                "Odwołanie realizowane przy użyciu interfejsu " +
                "ISettableNamedPerson.");
            if (settableName != null && settableName.Contains(" "))
            {
                // Nie można ustawić wartości, jeśli zawiera ona znak
                // odstępu.
                return;
            }
            settableName = value;
        }
    }
}